" Vim Keymap file for Japanese (ROMA)
" Maintainer: MURAOKA Taro <koron.kaoriya@gmail.com>
" Last Change: 15-Dec-2025.

scriptencoding utf-8

" Use this short name in the status line.
let b:keymap_name = "jpn"

loadkeymap

" あ行
a	あ
i	い
u	う
e	え
o	お

xa	ぁ
xi	ぃ
xu	ぅ
xe	ぇ
xo	ぉ

A	ア
I	イ
U	ウ
E	エ
O	オ

xA	ァ
xI	ィ
xU	ゥ
xE	ェ
xO	ォ

va	ヴァ
vA	ヴァ
vi	ヴィ
vI	ヴィ
vu	ヴ
vU	ヴ
ve	ヴェ
vE	ヴェ
vo	ヴォ
vO	ヴォ

" か行
ka	か
ki	き
ku	く
ke	け
ko	こ

kya	きゃ
kyu	きゅ
kyo	きょ

ga	が
gi	ぎ
gu	ぐ
ge	げ
go	ご

gya	ぎゃ
gyu	ぎゅ
gyo	ぎょ

kA	カ
kI	キ
kU	ク
kE	ケ
kO	コ

kyA	キャ
kyU	キュ
kyO	キョ

gA	ガ
gI	ギ
gU	グ
gE	ゲ
gO	ゴ

gyA	ギャ
gyU	ギュ
gyO	ギョ

" さ行
sa	さ
si	し
su	す
se	せ
so	そ

sya	しゃ
syu	しゅ
syo	しょ

za	ざ
zi	じ
ji	じ
zu	ず
ze	ぜ
zo	ぞ

zya	じゃ
jya	じゃ
zyu	じゅ
jyu	じゅ
zyo	じょ
jyo	じょ

sA	サ
sI	シ
sU	ス
sE	セ
sO	ソ

syA	シャ
syU	シュ
syO	ショ

zA	ザ
zI	ジ
zU	ズ
zE	ゼ
zO	ゾ

zyA	ジャ
zyU	ジュ
zyO	ジョ

" た行
ta	た
ti	ち
chi	ち
tu	つ
tsu	つ
te	て
to	と

tya	ちゃ
cha	ちゃ
tyu	ちゅ
chu	ちゅ
tyo	ちょ
cho	ちょ

da	だ
di	ぢ
du	づ
dsu	づ
de	で
do	ど

dya	ぢゃ
dyu	ぢゅ
dyo	ぢょ

xtu	っ
xtsu	っ

tA	タ
tI	チ
chI	チ
tU	ツ
tsU	ツ
tE	テ
tO	ト

tyA	チャ
chA	チャ
tyU	チュ
chU	チュ
tyO	チョ
chO	チョ

dA	ダ
dI	ヂ
dU	ヅ
dsU	ヅ
dE	デ
dO	ド

dyA	ヂャ
dyU	ヂュ
dyO	ヂョ

xtU	ッ
xtsU	ッ

" な行
na	な
ni	に
nu	ぬ
ne	ね
no	の

nya	にゃ
nyu	にゅ
nyo	にょ

nA	ナ
nI	ニ
nU	ヌ
nE	ネ
nO	ノ

nyA	ニャ
nyU	ニュ
nyO	ニョ

" は行
ha	は
hi	ひ
hu	ふ
he	へ
ho	ほ

hya	ひゃ
hyu	ひゅ
hyo	ひょ

ba	ば
bi	び
bu	ぶ
be	べ
bo	ぼ

bya	びゃ
byu	びゅ
byo	びょ

pa	ぱ
pi	ぴ
pu	ぷ
pe	ぺ
po	ぽ

pya	ぴゃ
pyu	ぴゅ
pyo	ぴょ

hA	ハ
hI	ヒ
hU	フ
hE	ヘ
hO	ホ

hyA	ヒャ
hyU	ヒュ
hyO	ヒョ

bA	バ
bI	ビ
bU	ブ
bE	ベ
bO	ボ

byA	ビャ
byU	ビュ
byO	ビョ

pA	パ
pI	ピ
pU	プ
pE	ペ
pO	ポ

pyA	ピャ
pyU	ピュ
pyO	ピョ

" ま行
ma	ま
mi	み
mu	む
me	め
mo	も

mya	みゃ
myu	みゅ
myo	みょ

mA	マ
mI	ミ
mU	ム
mE	メ
mO	モ

myA	ミャ
myU	ミュ
myO	ミョ

" や行
ya	や
yu	ゆ
yo	よ

xya	ゃ
xyu	ゅ
xyo	ょ

yA	ヤ
yU	ユ
yO	ヨ

xyA	ャ
xyU	ョ
xyO	ョ

" ら行
ra	ら
ri	り
ru	る
re	れ
ro	ろ

rya	りゃ
ryu	りゅ
ryo	りょ

rA	ラ
rI	リ
rU	ル
rE	レ
rO	ロ

ryA	リャ
ryU	リュ
ryO	リョ

" わ行
wa	わ
wi	ゐ
we	ゑ
wo	を

wA	ワ
wI	ヰ
wE	ヱ
wO	ヲ

" ん
nn ん
nN ン

" っ
xxa	っぁ
xxi	っぃ
xxu	っぅ
xxe	っぇ
xxo	っぉ

xxA	ッァ
xxI	ッィ
xxU	ッゥ
xxE	ッェ
xxO	ッォ

vva	ッヴァ
vvA	ッヴァ
vvi	ッヴィ
vvI	ッヴィ
vvu	ッヴ
vvU	ッヴ
vve	ッヴェ
vvE	ッヴェ
vvo	ッヴォ
vvO	ッヴォ

kka	っか
kki	っき
kku	っく
kke	っけ
kko	っこ

kkya	っきゃ
kkyu	っきゃ
kkyo	っきゃ

gga	っが
ggi	っぎ
ggu	っぐ
gge	っげ
ggo	っご

ggya	っぎゃ
ggyu	っぎゅ
ggyo	っぎょ

kkA	ッカ
kkI	ッキ
kkU	ック
kkE	ッケ
kkO	ッコ

kkyA	ッキャ
kkyU	ッキュ
kkyO	ッキョ

ggA	ッガ
ggI	ッギ
ggU	ッグ
ggE	ッゲ
ggO	ッゴ

ggyA	ッギャ
ggyU	ッギュ
ggyO	ッギョ

ssa	っさ
ssi	っし
ssu	っす
sse	っせ
sso	っそ

ssya	っしゃ
ssyu	っしゅ
ssyo	っしょ

zza	っざ
zzi	っじ
jji	っじ
zzu	っず
zze	っぜ
zzo	っぞ

zzya	っじゃ
jjya	っじゃ
zzyu	っじゅ
jjyu	っじゅ
zzyo	っじょ
jjyo	っじょ

ssA	ッサ
ssI	ッシ
ssU	ッス
ssE	ッセ
ssO	ッソ

ssyA	ッシャ
ssyU	ッシュ
ssyO	ッショ

zzA	ッザ
zzI	ッジ
zzU	ッズ
zzE	ッゼ
zzO	ッゾ

zzyA	ッジャ
zzyU	ッジュ
zzyO	ッジョ

tta	った
tti	っち
cchi	っち
ttu	っつ
ttsu	っつ
tte	って
tto	っと

ttya	っちゃ
ccha	っちゃ
ttyu	っちゅ
cchu	っちゅ
ttyo	っちょ
ccho	っちょ

dda	っだ
ddi	っぢ
ddu	っづ
ddsu	っづ
dde	っで
ddo	っど

ddya	っぢゃ
ddyu	っぢゅ
ddyo	っぢょ

xxtu	っっ
xxtsu	っっ

ttA	ッタ
ttI	ッチ
cchI	ッチ
ttU	ッツ
ttsU	ッツ
ttE	ッテ
ttO	ット

ttyA	ッチャ
cchA	ッチャ
ttyU	ッチュ
cchU	ッチュ
ttyO	ッチョ
cchO	ッチョ

ddA	ッダ
ddI	ッヂ
ddU	ッヅ
ddsU	ッヅ
ddE	ッデ
ddO	ッド

ddyA	ッヂャ
ddyU	ッヂュ
ddyO	ッヂョ

xxtU	ッッ
xxtsU	ッッ

" nna	っな
" nni	っに
" nnu	っぬ
" nne	っね
" nno	っの

" nnya	っにゃ
" nnyu	っにゅ
" nnyo	っにょ

" nnA	ッナ
" nnI	ッニ
" nnU	ッヌ
" nnE	ッネ
" nnO	ッノ

" nnyA	ッニャ
" nnyU	ッニュ
" nnyO	ッニョ
 
hha	っは
hhi	っひ
hhu	っふ
hhe	っへ
hho	っほ

hhya	っひゃ
hhyu	っひゅ
hhyo	っひょ

bba	っば
bbi	っび
bbu	っぶ
bbe	っべ
bbo	っぼ

bbya	っびゃ
bbyu	っびゅ
bbyo	っびょ

ppa	っぱ
ppi	っぴ
ppu	っぷ
ppe	っぺ
ppo	っぽ

ppya	っぴゃ
ppyu	っぴゅ
ppyo	っぴょ

hhA	ッハ
hhI	ッヒ
hhU	ッフ
hhE	ッヘ
hhO	ッホ

hhyA	ッヒャ
hhyU	ッヒュ
hhyO	ッヒョ

bbA	ッバ
bbI	ッビ
bbU	ッブ
bbE	ッベ
bbO	ッボ

bbyA	ッビャ
bbyU	ッビュ
bbyO	ッビョ

ppA	ッパ
ppI	ッピ
ppU	ップ
ppE	ッペ
ppO	ッポ

ppyA	ッピャ
ppyU	ッピュ
ppyO	ッピョ

mma	っま
mmi	っみ
mmu	っむ
mme	っめ
mmo	っも

mmya	っみゃ
mmyu	っみゅ
mmyo	っみょ

mmA	ッマ
mmI	ッミ
mmU	ッム
mmE	ッメ
mmO	ッモ

mmyA	ッミャ
mmyU	ッミュ
mmyO	ッミョ

yya	っや
yyu	っゆ
yyo	っよ

xxya	っゃ
xxyu	っゅ
xxyo	っょ

yyA	ッヤ
yyU	ッユ
yyO	ッヨ

xxyA	ッャ
xxyU	ッョ
xxyO	ッョ

rra	っら
rri	っり
rru	っる
rre	っれ
rro	っろ

rrya	っりゃ
rryu	っりゅ
rryo	っりょ

rrA	ッラ
rrI	ッリ
rrU	ッル
rrE	ッレ
rrO	ッロ

rryA	ッリャ
rryU	ッリュ
rryO	ッリョ

wwa	っわ
wwi	っゐ
wwe	っゑ
wwo	っを

wwA	ッワ
wwI	ッヰ
wwE	ッヱ
wwO	ッヲ

" 記号
-	ー
,	、
.	。
[	「
]	」
